<?php
namespace Fraktjakt\Fraktjaktmodule\Model\Carrier;

use Magento\Quote\Model\Quote\Address\RateRequest;
#use Magento\Shipping\Helper\Carrier as CarrierHelper;
#use Magento\Shipping\Model\Carrier\AbstractCarrierOnline;
#use Magento\Shipping\Model\Rate\Result;
#use Magento\Framework\Xml\Security;


class Fraktjakt extends \Magento\Shipping\Model\Carrier\AbstractCarrier implements
    \Magento\Shipping\Model\Carrier\CarrierInterface
{
    /**
     * @var string
     */
    protected $_code = 'fraktjakt';
    
    protected $_totalfinalp = 0;
    
	
	protected $_logger;
    /**
     * @var bool
     */
    protected $_isFixed = true;

    /**
     * @var \Magento\Shipping\Model\Rate\ResultFactory
     */
    protected $_rateResultFactory;


    /**
     * @var \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory
     */
    protected $_rateMethodFactory;

	/**
     * @var \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory
     */
    protected $_productCollectionFactory;
    
    protected $productFactory;
    
    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Shipping\Model\Rate\ResultFactory $rateResultFactory
     * @param \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory
     * @param array $data
     */
     public function __construct(
         \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
         \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
         \Psr\Log\LoggerInterface $logger,
         \Magento\Shipping\Model\Rate\ResultFactory $rateResultFactory,
         \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
         \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
         \Magento\Catalog\Model\ProductFactory $productFactory,
         array $data = []
     ) {
         $this->_rateResultFactory = $rateResultFactory;
         $this->_rateMethodFactory = $rateMethodFactory;
          $this->_productCollectionFactory = $productCollectionFactory;
          $this->productFactory = $productFactory;
 		$this->_logger = $logger;
         parent::__construct($scopeConfig, $rateErrorFactory, $logger, $data);
     }

/*	public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
        \Psr\Log\LoggerInterface $logger,
        Security $xmlSecurity,
        \Magento\Shipping\Model\Simplexml\ElementFactory $xmlElFactory,
        \Magento\Shipping\Model\Rate\ResultFactory $rateFactory,
        \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
        \Magento\Shipping\Model\Tracking\ResultFactory $trackFactory,
        \Magento\Shipping\Model\Tracking\Result\ErrorFactory $trackErrorFactory,
        \Magento\Shipping\Model\Tracking\Result\StatusFactory $trackStatusFactory,
        \Magento\Directory\Model\RegionFactory $regionFactory,
        \Magento\Directory\Model\CountryFactory $countryFactory,
        \Magento\Directory\Model\CurrencyFactory $currencyFactory,
        \Magento\Directory\Helper\Data $directoryData,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        CarrierHelper $carrierHelper,
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Framework\HTTP\ZendClientFactory $httpClientFactory,
        array $data = []
    ) {
        $this->_carrierHelper = $carrierHelper;
         $this->productFactory = $productFactory;
        $this->_httpClientFactory = $httpClientFactory;
        $this->_logger = $logger;
        parent::__construct(
            $scopeConfig,
            $rateErrorFactory,
            $logger,
            $xmlSecurity,
            $xmlElFactory,
            $rateFactory,
            $rateMethodFactory,
            $trackFactory,
            $trackErrorFactory,
            $trackStatusFactory,
            $regionFactory,
            $countryFactory,
            $currencyFactory,
            $directoryData,
            $stockRegistry,
            $data
        );
    }
*/
	public function log($data, $force =false)
    {
//         if($force || $this->getConfig('test_mode') || $this->getConfig('debug'))
//         {
            $this->_logger->debug("Fraktjakt: ".$data);
//         }
    }
    
    
    /**
     * @param RateRequest $request
     * @return \Magento\Shipping\Model\Rate\Result|bool
     */
     
      protected function _doShipmentRequest(\Magento\Framework\DataObject $request)
    {
      if (!$this->getConfigFlag('active')) {
            return false;
        }

        /** @var \Magento\Shipping\Model\Rate\Result $result */
        $result = $this->_rateResultFactory->create();
		
		$items_xml = $this->_getItems($request);
		
		$xml_bits  = $this->_makeXML($request, $items_xml);
		
		$this->log($xml_bits);
// 		die("\r\n yes");
    }
    public function collectRates(RateRequest $request)
    {
        if (!$this->getConfigFlag('active')) {
            return false;
        }

        /** @var \Magento\Shipping\Model\Rate\Result $result */
        $result = $this->_rateResultFactory->create();
		
		$items_xml = $this->_getItems($request);
		
		$xml_bits  = $this->_makeXML($request, $items_xml);
		
		$this->log($xml_bits);
// 		die("\r\n yes");
		
		$shippingPrice = $this->getConfigData('price');
		$method = $this->_rateMethodFactory->create();
		$method->setCarrier($this->_code);
		$method->setCarrierTitle($this->getConfigData('title'));
		$method->setMethod($this->_code);
		$method->setMethodTitle($this->getConfigData('name'));
		$method->setPrice($shippingPrice);
		$method->setCost($shippingPrice);
		$result->append($method);
        

        return $result;
    }
	
	private function setDefaults()
    {

        $this->_weight_low = 1;
        if(is_numeric($this->getConfigData('weight_low')))
        {
            $this->_weight_low = $this->getConfigData('weight_low');
        }

        $this->_default_widthlow = 1;
        if(is_numeric($this->getConfigData('default_widthlow')))
        {
            $this->_default_widthlow = $this->getConfigData('default_widthlow');
        }

        $this->_default_widthhigh = 1;
        if(is_numeric($this->getConfigData('default_widthhigh')))
        {
            $this->_default_widthhigh = $this->getConfigData('default_widthhigh');
        }

        $this->_default_heightlow = 1;
        if(is_numeric($this->getConfigData('default_heightlow')))
        {
            $this->_default_heightlow = $this->getConfigData('default_heightlow');
        }

        $this->_default_heighthigh = 1;
        if(is_numeric($this->getConfigData('default_heighthigh')))
        {
            $this->_default_heighthigh = $this->getConfigData('default_heighthigh');
        }
        $this->_default_lengthlow = 1;

        if(is_numeric($this->getConfigData('default_lengthlow')))
        {
            $this->_default_lengthlow = $this->getConfigData('default_lengthlow');
        }

        $this->_default_lengthhigh = 1;
        if(is_numeric($this->getConfigData('default_lengthhigh')))
        {
            $this->_default_lengthhigh = $this->getConfigData('default_lengthhigh');
        }
    }
    
    
	/*
	* get all items array
	*/
	public function _getItems($request)
	{
		$this->_totalPrice = 0.0;
		$this->_package_width = 0;
	    $this->_package_height = 0;
	    $this->_package_length = 0;
	    $this->shipping_weight = 0;
        $this->_items_xml = "";
        $this->setDefaults();
        $freeBoxes = 0;
		
		
		
		$items = array();
// 		var_dump($request->debug());
// 		die;
		///return get_class_methods($request);
// 		echo get_class($request);
// 		die;
		$packageItems = $request->getAllItems();
		$productIds = [];
        foreach ($packageItems as $itemShipment) {
			$free_shipping = false;
            $free_shipping_children = false;
//             $item = new \Magento\Framework\DataObject();
//             $item->setData($itemShipment);
			if ($itemShipment->getProduct()->isVirtual() || $itemShipment->getParentItem())
			{
				continue;
			}
// 				$productIds[] = $itemShipment->getProductId();
            if ($itemShipment->getHasChildren() && $itemShipment->isShipSeparately())
            {
                foreach ($itemShipment->getChildren() as $child)
                {
                    if ($child->getFreeShipping() && !$child->getProduct()->isVirtual())
                    {
                        continue;
                    }
                    // we add item to list

                }
            }
            elseif ($itemShipment->getFreeShipping())
            {
                continue;
            }
            
            
            $product = $this->productFactory->create();
			$product->load($itemShipment->getProductId());
// 			$items[] = $product->debug();

			$this->_items_xml .= $this->getItemXml($itemShipment,$product);
			$this->_totalfinalp .= $this->getItemTotalPrice($itemShipment,$product);
			
        }
        $data =  $this->_items_xml;
        $this->_items_xml  = '';
        $this->_totalPrice  = 0;
        return $data;
        
//         $productCollection = $this->_productCollectionFactory->create()->addStoreFilter(
//             $request->getStoreId()
//         )->addFieldToFilter(
//             'entity_id',
//             ['in' => $productIds]
//         )->addAttributeToSelect(
//            array( 'name','length' , 'width' , 'height' , 'weight_measure' , 'readytoship' , 'dimension_units')
//         );
//         foreach ($productCollection as $product) {
//             //$countriesOfManufacture[$product->getId()] = $product->getCountryOfManufacture();
//             $items[] = $product->debug();
//         }

		
		
        
       
	
	}
	
	 public function _makeXML( $request, $items)
    {
        //mage::log("--- items --- " . print_r($items));
        $consignorID = $this->getConfigData('consignorID');
		$consignorkey = $this->getConfigData('onsignorkey');
        $store_currency = $request->getPackageCurrency()->getCurrencyCode();
//         var_dump($request->debug());
//         var_dump($request->getPackageCurrency()->getCurrencyCode());
//         var_dump($request->getBaseCurrency()->getCurrencyCode());
// 		die("\r\nyes");
        //added var checks + instantiations for cases like !request
        $issues = 0;
        $hasaddress = false;
       //  $customerAddressId = Mage::getSingleton('customer/session')->getCustomer()->getDefaultShipping();
//         if ($customerAddressId){
//             $mainAddress = Mage::getModel('customer/address')->load($customerAddressId);
//             $hasaddres = true;
//         }

        //city
        if ($request->getDestCity()) {
            $city = $request->getDestCity();
        } elseif ($hasaddress) {
            $city = $mainAddress->getCity();
        } else {
            $city = "";
            //$issues++;
        }

        //region code
        if ($request->getDestRegionCode()) {
            $prov = $request->getDestRegionCode();
        } elseif ($hasaddress) {
            $prov = $mainAddress->getRegionId();
        } else {
            $prov = "";
            //$issues++;
        }

       //street line
if ($request->getDestStreet()) {
            $streetline = $request->getDestStreet();
        } elseif ($hasaddress) {
            $streetline = $mainAddress->getStreet1();
			$streetline1 = $mainAddress->getStreet2();
        } else {
            $streetline = "";
			$streetline1 = "";
            //$issues++;
        }

    

        //country code
        if ($request->getDestCountryId()) {
            $destCountry = $request->getDestCountryId();
        } elseif ($hasaddress) {
            $destCountry = $mainAddress->getCountryId();
        } else {
            $destCountry = "";
            $issues++;
        }


        $country = $this->_countryFactory->create()->load($destCountry)->getData('iso2_code');
        

        $postal = '';

        //postal code
        if (($request->getDestPostcode()) && ($request->getDestPostcode() != "-")) {
            $postal = $request->getDestPostcode();
        } elseif ($hasaddress) {
            $postal = $mainAddress->getPostcode();
        } else {
            $postal = "";
            $issues++;
        }



        if ($request->getPostcode())
        {
            $spostalcode = $request->getPostcode();
        }
        else
        {
            $spostalcode = "";
        }

        // later this can be switched based on customers selected language on site (EN || SV)
        $return_lang = 'EN';
        if($this->returnSwedish())
        {
            $return_lang = 'sv';
        }
        //mage::log($issues);
        if ($issues == 0) {
			

            $xml_bits = '<?xml version="1.0" encoding="iso-8859-1"?>';
			 $xml_bits.='
<shipment xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <value>'.sprintf("%01.2f", $this->_totalfinalp).'</value>
  ';
  $xml_bits.= "
  <consignor>
    <id>".$consignorID."</id>
    <key>".$consignorkey."</key>
    <currency>".$store_currency."</currency>
    <language>".$return_lang."</language>
	<encoding>ISO 8859-1</encoding>
  </consignor>
  <no_agents>0</no_agents>
  <agents_in>1</agents_in>
  <parcels>
  ".$items."
  </parcels>
  <address>
  <street_address_1>".$streetline."</street_address_1>
  <street_address_2>".$streetline1."</street_address_2>
  <postal_code>".$postal."</postal_code>
  <city_name>".$city."</city_name>
  <residential>1</residential>
  <country_code>".$country."</country_code>
  <country_subdivision_code>F</country_subdivision_code>
  </address>
  <referrer_code></referrer_code>
</shipment>
";



       /*echo  $xml_bits;
	   exit;*/
            unset($return_lang);
			unset($consignorID);
			unset($consignorkey);
            unset($spostalcode);
            unset($items);
            unset($city);
            unset($prov);
			unset($streetline);
			unset($streetline1);
            unset($country);
            unset($postal);

            return $xml_bits;
        } else {
            unset($return_lang);
          	unset($consignorID);
			unset($consignorkey);
            unset($spostalcode);
            unset($items);
            unset($city);
            unset($prov);
			unset($streetline);
			unset($streetline1);
            unset($country);
            unset($postal);

            return false;
        }

    }
	
	 private function getConvertedWeight($w,$u)
    {
        $weight = $w;
        switch($u)
        {
            case 'lb':
                $weight = round($w*0.4535,2);
                break;
            case 'gr':
                $weight = round($w*0.001,2);
                break;
            case 'oz':
                $weight = round($w*0.028349,2);
                break;
            case 'kg':
            default:
                $weight = $w;
                break;
        }
        return $weight;
    }

    private function getConvertedMeasure($w,$u)
    {
        $unit = $w;
        switch($u)
        {
            case 'mm':
                $unit = round($w*0.1,0);
                break;
            case 'ft':
                $unit = round($w*30.48,0);
                break;
            case 'in':
                $unit = round($w*2.54,0);
                break;
		    case 'm':
                $unit = round($w*100,0);
                break;
			case 'km':
                $unit = round($w*100000,0);
                break;	
            case 'cm':
            default:
                $unit = $w;
                break;
        }
        return $unit;
    }
	
	
	  private function getItemTotalPrice($item,$product)
    {
		 $qty =  (int)$item->getQty() ? (int)$item->getQty() : 1;
//         $product = Mage::getModel('catalog/product')->load( $item->getProductId() );



        //$this->_totalPrice += $product->getFinalPrice() * $qty;
        if($this->getConfigData('product_cost') && $product->getCost() > 0)
        {
            $this->_totalPrice = $product->getCost() * $qty;
        }
        else
        {
            $this->log("p p " . $product->getFinalPrice() . " and i P  ". $product->getPrice());
            $this->_totalPrice = $product->getFinalPrice() * $qty;
        }
		
		return $this->_totalPrice;
	}
	
	
	
	
	 private function getItemXml($item,$product)
    {
        // Get quanity for each Item and multiply by volume
        $qty =  (int)$item->getQty() ? (int)$item->getQty() : 1;
//         $product = Mage::getModel('catalog/product')->load( $item->getProductId() );
       //  $product = $this->productFactory->create();
// 		$product->load($item->getProductId());



        //$this->_totalPrice += $product->getFinalPrice() * $qty;
        if($this->getConfigData('product_cost') && $product->getCost() > 0)
        {
            $this->_totalPrice += $product->getCost() * $qty;
        }
        else
        {
        
            $this->log("p p " . $product->getFinalPrice() . " and i P  ". $product->getPrice());
            $this->_totalPrice += $product->getFinalPrice() * $qty;
        }
// die('aaa');
        $height = $this->getConvertedMeasure($product->getHeight(), $product->getDimensionUnits());
        //$weight = $this->getConvertedWeight($product->getWeight(),$product->getWeightUnits())*$qty;
        $weight = $this->getConvertedWeight($product->getWeight(),$product->getWeightMeasure());
        $width =  $this->getConvertedMeasure($product->getWidth(), $product->getDimensionUnits());
        $length = $this->getConvertedMeasure($product->getLength(), $product->getDimensionUnits());
        $title = substr($product->getSku().';'.preg_replace('/[^a-z0-9\s\'\.\_]/i','',substr($product->getName(),0,32)." ..."),0,32);
        $Readytoship = $product->getReadytoship();

        if(intval($length) < 1 || intval($width) < 1 || intval($height) < 1 )
        {
            $length = $width = $height = 1;
        }

        $Readytoship = "";
        if($product->getReadytoship() != 1)
        {
            $Readytoship = '';
			
        }

        if(ceil($weight) <= 0.0000)
        {
            $weight = .7; //default to 7.7 kg
        }

        if($height < 1 || !is_numeric($height))
        {
            $height = $this->_default_heightlow; // just a low default
            if($weight >= $this->_weight_low) // less than 1k no height  (default 2)
            {
                $height = $this->_default_heighthigh;
            }

        }

        if($width < 1 || !is_numeric($width))
        {
            $width = $this->_default_widthlow; // just a low default
            if($weight >= $this->_weight_low)
            {			   // less than 1k no height  (default 2)
                $width = $this->_default_widthhigh;
            }
        }

        // Create default value for length should value be missing
        if($length < 1 || !is_numeric($length))
        {
            $length = $this->_default_lengthlow; // just a low default
            if($weight >= $this->_weight_low) // less than 1k no height  (default 2)
            {
                $length = $this->_default_lengthhigh;
            }
        }
$aweight = $weight;
/*$aheight = $height*$qty;*/

if($product->getReadytoship() != 1)
        {
           
		$this->_package_height += $height;  
		if($width > $this->_package_width) $this->_package_width = $width;  
		if($length > $this->_package_length) $this->_package_length = $length;
		$this->shipping_weight += $aweight;  
		    
	

			
			 $items_xml = "\n
<parcel>
  <weight>{$this->shipping_weight}</weight>
  <length>{$this->_package_length}</length>
  <width>{$this->_package_width}</width>
  <height>{$this->_package_height}</height>
</parcel>
";
			
        }
		else
		{
			 $items_xml = "\n
<parcel>
  <weight>{$aweight}</weight>
  <length>{$length}</length>
  <width>{$width}</width>
  <height>{$height}</height>
</parcel>
";
		}


       
        return $items_xml;
    }
    
    
    /**
     * @return array
     */
    public function getAllowedMethods()
    {
		
//         return [$this->_code=> $this->getConfigData('name')];
        
         $arr = array(
            30 => "Schenker Privpak AB - Privatpaket",
            92 => "Bussgods - Bussbox 5 kg (emballage ingår)",
            25 => "Bussgods - Privat",
            84 => "Schenker AB - DB SCHENKERprivpak, Ombud - Standard",
            88 => "Schenker AB - DB SCHENKERprivpak, Till jobbet (Leverans till privatpersonsarbetsplats) (inkl utkörning)",
            85 => "Schenker AB - DB SCHENKERprivpak, Hem - Dag utan avisering och kvittens (inklutkörning)",
			100 => "Bussgods - Bussgods Prio",
            86 => "Schenker AB - DB SCHENKERprivpak, Hem- Dag med avisering (inkl utkörning)",
            87 => "Schenker AB - DB SCHENKERprivpak, Hem- kväll med avisering (inkl utkörning)"
        );
        return $arr;
    }
    
    /*
    	Send Data to fraktjakt
    */
    public function _postBits($xml)
    {
       
	     if($this->getConfigData('test_mode') == 1)
        {
             $url = "http://api2.fraktjakt.se/fraktjakt/query_xml";
        }
		else
		{
			 $url = "http://api1.fraktjakt.se/fraktjakt/query_xml";
		}
	   $httpHeaders = array(
      // BOF: PHP bug #47906 circumvention (http://bugs.php.net/bug.php?id=47906)
        "Expect: ", // Disable the 100-continue header
      // EOF: PHP bug #47906 circumvention
        "Accept-Charset: ISO 8859-1",
        "Content-type: application/x-www-form-urlencoded"
      );
	   $httpPostParams = array(
          'md5_checksum' => md5($xml),
          'xml' => utf8_encode($xml)
        );
		
		 if (is_array($httpPostParams)) {
          foreach ($httpPostParams as $key => $value) {
            $httpPostParams[$key] = $key .'='. urlencode($value);
          }
          $httpPostParams = implode('&', $httpPostParams); 
        }
	  
	  
	  
	   /*echo "<pre>";
	   print_r($xml);*/
      $ch = curl_init();
       /* 
        curl_setopt($ch, CURLOPT_POST,1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,urlencode($xml));
        curl_setopt($ch, CURLOPT_URL,$url);
        curl_setopt($ch, CURLOPT_PORT,30000);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        $qresult = curl_exec($ch);*/
		curl_setopt($ch, CURLOPT_FAILONERROR, 0); // fail on errors
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, 1); // forces a non-cached connection
        if ($httpHeaders) curl_setopt($ch, CURLOPT_HTTPHEADER, $httpHeaders); // set http headers
          curl_setopt($ch, CURLOPT_POST, 1); // initialize post method
          curl_setopt($ch, CURLOPT_POSTFIELDS,urlencode($xml));
        curl_setopt($ch, CURLOPT_URL,$url);
		 curl_setopt($ch, CURLOPT_POSTFIELDS, $httpPostParams); // variables to post
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // return into a variable
          curl_setopt($ch, CURLOPT_TIMEOUT, 30); // timeout after 30s
          $qresult = curl_exec($ch);
		
		
		/*curl_error($ch);
		print_r($qresult);
		exit;*/
        if (curl_errno($ch))
        {
            $tmp = $qresult;
            $qresult =  "<code>2</code>\n";
            $qresult =  "<error_message>Error communicating with Fraktjakt_Fraktjaktmodule " .
                curl_error($ch)."</error_message>\n".$tmp;
        }
        else
        {
            curl_close($ch);
        }


        unset($ch);
        unset($tmp);
        unset($xml);
        return $qresult;
    }

}
