<?php
namespace Fraktjakt\Fraktjaktmodule\Setup;

use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Catalog\Model\ResourceModel\Eav\Attribute;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class UpgradeData implements UpgradeDataInterface
{
private $eavSetupFactory;
public function __construct(EavSetupFactory $eavSetupFactory)
{
$this->eavSetupFactory = $eavSetupFactory;
}
public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
{
/** @var EavSetup $eavSetup */
$eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
/**
* Add attributes to the eav/attribute
*/
$eavSetup->addAttribute(
\Magento\Catalog\Model\Product::ENTITY,
'length',
[
'type' => 'decimal',
'backend' => '',
'frontend' => '',
'label' => 'Length',
'input' => 'text',
'class' => '',
'source' => '',
'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
'visible' => true,
'required' => false,
'user_defined' => false,
'default' => 0,
'searchable' => false,
'filterable' => false,
'comparable' => false,
'visible_on_front' => false,
'used_in_product_listing' => true,
'unique' => false,
'apply_to' => ''
]
);
$eavSetup->addAttribute(
\Magento\Catalog\Model\Product::ENTITY,
'width',
[
'type' => 'decimal',
'backend' => '',
'frontend' => '',
'label' => 'Width',
'input' => 'text',
'class' => '',
'source' => '',
'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
'visible' => true,
'required' => false,
'user_defined' => false,
'default' => 0,
'searchable' => false,
'filterable' => false,
'comparable' => false,
'visible_on_front' => false,
'used_in_product_listing' => true,
'unique' => false,
'apply_to' => ''
]
);
$eavSetup->addAttribute(
\Magento\Catalog\Model\Product::ENTITY,
'height',
[
'type' => 'decimal',
'backend' => '',
'frontend' => '',
'label' => 'Height',
'input' => 'text',
'class' => '',
'source' => '',
'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
'visible' => true,
'required' => false,
'user_defined' => false,
'default' => 0,
'searchable' => false,
'filterable' => false,
'comparable' => false,
'visible_on_front' => false,
'used_in_product_listing' => true,
'unique' => false,
'apply_to' => ''
]
);
$eavSetup->addAttribute(
\Magento\Catalog\Model\Product::ENTITY,
'weight_measure',
[
'type' => 'varchar',
'backend' => '',
'frontend' => '',
'label' => 'Weight Units',
'input' => 'select',
'class' => '',
'source' => 'Fraktjakt\Fraktjaktmodule\Model\Source\Weightunits',
'source_model' => 'Fraktjakt\Fraktjaktmodule\Model\Source\Weightunits',
'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
'visible' => true,
'required' => false,
'user_defined' => false,
'default' => 0,
'searchable' => false,
'filterable' => false,
'comparable' => false,
'visible_on_front' => false,
'used_in_product_listing' => true,
'unique' => false,
'apply_to' => ''
]
);
$eavSetup->addAttribute(
\Magento\Catalog\Model\Product::ENTITY,
'readytoship',
[
'type' => 'varchar',
'backend' => 'Magento\Catalog\Model\Product\Attribute\Backend\Boolean',
'frontend' => '',
'label' => 'Ready to Ship',
'input' => 'select',
'class' => '',
'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
'visible' => true,
'required' => false,
'user_defined' => false,
'default' => 0,
'searchable' => false,
'filterable' => false,
'comparable' => false,
'visible_on_front' => false,
'used_in_product_listing' => true,
'unique' => false,
'apply_to' => ''
]
);


		if (version_compare($context->getVersion(), '1.0.4', '<')) {
			$eavSetup->addAttribute(
			\Magento\Catalog\Model\Product::ENTITY,
			'dimension_units',
			[
			'type' => 'varchar',
			'backend' => '',
			'frontend' => '',
			'label' => 'Dimension Units',
			'input' => 'select',
			'class' => '',
			'source' => 'Fraktjakt\Fraktjaktmodule\Model\Source\Dimentionunits',
			'source_model' => 'Fraktjakt\Fraktjaktmodule\Model\Source\Dimentionunits',
			'global' => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_GLOBAL,
			'visible' => true,
			'required' => false,
			'user_defined' => false,
			'default' => 0,
			'searchable' => false,
			'filterable' => false,
			'comparable' => false,
			'visible_on_front' => false,
			'used_in_product_listing' => true,
			'unique' => false,
			'apply_to' => ''
			]
			);
        }


}
}
